<?php
// -- Include the required data and requirements for this page
include("templates/headers/inc.php");

// Include the JS file
$js_files = array("js/pages/manage-users.js");

// Metadata informations of this page
$page_title = "Manage Users";
$page_slug	= "manage-users";

// Get website config
$site_config = $dbh->prepare("SELECT * FROM config WHERE config_name IN ('website_name','website_tagline')");
$site_config->execute();

$config_array = array();

while($config = $site_config->fetch(PDO::FETCH_ASSOC)) {
	$config_array[$config["config_name"]] = $config["config_value"];
}

$website_name = $config_array["website_name"];
$website_tagline = $config_array["website_tagline"];

// -- General checks and redirects
// If we have a session, redirect !
if(!$_SESSION || !isset($_SESSION["USER_ID"])) {
	header("Location: index.php?action=need_log_in");
	exit;
}

if($_SESSION["RANK"] == 0) {
	header("Location: home.php?action=forbidden");
	exit;	
}

$user_id = $_SESSION["USER_ID"];

// Check if user exists...
$total_users = $dbh->prepare("	SELECT *
								FROM user
								ORDER BY created_at DESC
								");
					
$total_users->execute();

	
// -- Include the header template
include("templates/headers/admin_header.php")
?>

<div class="row">

	<div class="inner-container">	
		<div class="quiz_list_container">
			<div class="row row-stats">
				<div class="col-md-6">
					<h4><?php echo $total_users->rowCount(); ?> Total Users</h4>
				</div>
			</div>
			<?php
			if($total_users->rowCount() == 0) {
			?>
			<div class="alert alert-danger alert-center">
				No users are registered on the platform yet <i class="em em-anguished"></i>
			</div>
			<?php
			} else {
			?>
			<table class="table table-striped table-quizzes">
				<tr>
					<th>Photo</th>
					<th>Full Name</th>
					<th>Actions</th>
				</tr>
				<?php
				// Pagination
				$perpage = 15;
				$posts  = $total_users->rowCount();
				$pages  = ceil($posts / $perpage);
				
				$get_pages = isset($_GET['page']) ? $_GET['page'] : 1;
				
				$data = array(
	
					'options' => array(
						'default'   => 1,
						'min_range' => 1,
						'max_range' => $pages
						)
				);
		
				$number = trim($get_pages);
				$number = filter_var($number, FILTER_VALIDATE_INT, $data);
				$range  = $perpage * ($number - 1);
		
				$prev = $number - 1;
				$next = $number + 1;
					
				// Get list of all quiz
				$users_query = $dbh->prepare("SELECT * FROM user ORDER BY created_at DESC LIMIT :limit, :perpage");
				$users_query->bindParam(':perpage', $perpage, PDO::PARAM_INT);
				$users_query->bindParam(':limit', $range, PDO::PARAM_INT);
				$users_query->execute();
					
				while($user = $users_query->fetch(PDO::FETCH_ASSOC)) {					
				?>
				<tr class="quiz-line" data-id="<?php echo $user["id"]; ?>">
					<?php
					if($user["profile_picture"] == "") {	
					?>
					<td><div class="friend_profile_pic"><img src="img/default_avatar.jpg" /></div></td>
					<?php
					} else {
					?>
					<td><div class="friend_profile_pic"><img onerror="this.onerror=null;this.src='img/default_avatar.jpg';" src="<?php echo $user["profile_picture"]; ?>" /></div></td>
					<?php
					}	
					?>	
					<td><?php echo $user["fullname"]; ?></td>
					<td>
						<a href="edit-user.php?id=<?php echo $user["id"]; ?>" class="btn btn-primary btn-admin-edit btn-sm btn-block"><i class="fas fa-pencil-alt"></i></a>
						<a href="" class="btn btn-danger btn-delete btn-home-delete btn-sm btn-block" data-id="<?php echo $user["id"]; ?>"><i class="fas fa-times"></i></a>
					</td>
				</tr>
				<?php
				}	
				?>
			</table>
			<?php
			if($posts > 0) {
				if($pages > 1) {	
				?>
				<div class="pagination">
				<?php	
					echo "<div class='page-list'>";
	
					# first page
					if($number <= 1)
						echo "<span>&laquo; prev</span> | <a href=\"?page=$next\">next &raquo;</a>";
					
					# last page
					else if($number >= $pages)
						echo "<a href=\"?page=$prev\">&laquo; prev</a> | <span>next &raquo;</span>";
					
					# in range
					else
						echo "<a href=\"?page=$prev\">&laquo; prev</a> | <a href=\"?page=$next\">next &raquo;</a>";
	
					echo "</div>";
				?>
				</div>
				<?php
				}
			}	
			?>
			<?php
			}
			?>
		</div>
	</div>
					
</div>

<?php
// -- Include the footer template
include("templates/footers/global_footer.php");	
?>